/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorShakingModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> SHAKING = TConstruct.createKey((String)"shaking_armor");

    public ArmorShakingModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorShakingModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(SHAKING, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            LivingEntity attackerl;
            int level = (Integer)holder.get(SHAKING, (Object)0);
            if (level > 0 && attacker instanceof LivingEntity && living != (attackerl = (LivingEntity)attacker) && event.getAmount() > 0.0f) {
                Vec3 motionOld = attackerl.m_20184_();
                Vec3 motionNew = new Vec3(0.0, motionOld.f_82480_ <= 0.0 ? 0.4 : motionOld.f_82480_ + 1.0, 0.0);
                attackerl.m_20256_(motionNew);
                attackerl.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 2));
                attackerl.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 30, 2));
            }
        });
    }
}

